proc tabulate data = ghpb09 (where=(filingsize='1'));
class ent2 INS3 / PRELOADFMT;
TITLE 'Table A6. Balance Sheet of Group Health Plans with 100 or More Participants & Trusts';
title2 'by type of insurance and type of plan, 2009';
title3 '(numbers in millions)';
var CAST_AST 
	RECEIVABLES_AST
	GOVT_SEC_AST
	DEBT_INST_AST
	STOCK_AST
	PART_JOINT_INT_AST
	REAL_ESTATE_AST
	LOANS_AST
	DFE_AST
	REG_INVST_CO_AST
	INS_CO_GEN_AST
	OTHER_AST TOT_ASSETS_EOY_amt ;
table (TOT_ASSETS_EOY_amt ='TOTAL ASSETS'
	CAST_AST ='Cash'
	RECEIVABLES_AST='Receivables'
	GOVT_SEC_AST='US Government Securities'
	DEBT_INST_AST='Debt instruments'
	STOCK_AST='Stock'
	PART_JOINT_INT_AST='Partnership/Joint venture interests'
	REAL_ESTATE_AST='Real Estate'
	LOANS_AST='Loans'
	DFE_AST='Assets in direct filing entities'
	REG_INVST_CO_AST='Assets in registered investment companies'
	INS_CO_GEN_AST='Assets in insurance co. general accounts'
	OTHER_AST ='Other')*sum=' '*f=m12f., 
(all='All Plans' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
footnote;
run;
